-- Deploy burningswell_db:update_photos_likes_trigger to pg

BEGIN;

CREATE TRIGGER "update_photo_likes"
  AFTER INSERT OR UPDATE OR DELETE ON "likes"."photos"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('photos', 'likes', 'photo_id');

CREATE TRIGGER "update_photo_likes_truncate"
  AFTER TRUNCATE ON "likes"."photos"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "counter_cache"('photos', 'likes', 'photo_id');

COMMIT;
