-- Deploy us_value

BEGIN;

CREATE OR REPLACE FUNCTION "us_value"(value DOUBLE PRECISION, unit TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE unit
  WHEN 'k' THEN
    RETURN kelvin_to_fahrenheit(value);
  WHEN 'm' THEN
    RETURN meter_to_feet(value);
  WHEN 'm/s' THEN
    RETURN meter_per_second_to_miles_per_hour(value);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
