-- Deploy create_weather_spot_nowcasts_view

BEGIN;

CREATE MATERIALIZED VIEW weather."spot_nowcasts" AS
  SELECT DISTINCT ON ("spot_id", "variable_id") *
    FROM weather."spot_forecasts"
   WHERE "valid_time" >= clock_timestamp()
   ORDER BY "spot_id", "variable_id", "valid_time";

CREATE INDEX "weather_spot_nowcasts_spot_id" ON weather."spot_nowcasts" ("spot_id");
CREATE UNIQUE INDEX "weather_spot_nowcasts_spot_id_variable_id_valid_time" ON weather."spot_nowcasts" ("spot_id", "variable_id", "valid_time");

COMMIT;
