-- Deploy update_region_port_count

BEGIN;

CREATE OR REPLACE FUNCTION "update_region_port_count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE regions
     SET "port_count" = u.count
    FROM (SELECT regions.id, count(ports.id)
            FROM regions
       LEFT JOIN ports
              ON ports."region_id" = regions.id
        GROUP BY regions.id) AS u
   WHERE regions.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
