-- Deploy create_regions_table

BEGIN;

CREATE TABLE "regions" (
  "id" SERIAL PRIMARY KEY,
  "country_id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "name" CITEXT NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "airport_count" INTEGER NOT NULL DEFAULT 0,
  "port_count" INTEGER NOT NULL DEFAULT 0,
  "spot_count" INTEGER NOT NULL DEFAULT 0,
  "user_count" INTEGER NOT NULL DEFAULT 0,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "regions_name_fulltext_index" ON "regions" USING gin(to_tsvector('english', "name"));
CREATE INDEX "regions_geom_index" ON "regions" USING gist("geom");

CREATE TRIGGER "regions_created_at_trigger"
  BEFORE INSERT ON "regions" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "regions_updated_at_trigger"
  BEFORE UPDATE ON "regions" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
