-- Deploy add_time_zone_id_to_spots

BEGIN;

ALTER TABLE "spots" ADD COLUMN "time_zone_id" INTEGER REFERENCES "time_zones" ("id") ON DELETE SET NULL;

UPDATE spots
   SET "time_zone_id" = t.id
  FROM (SELECT "time_zones".id, spots.id AS "spot_id"
          FROM "time_zones"
          JOIN spots
            ON ST_Contains("time_zones"."geom", spots.location)) AS t
  WHERE spots.id = t."spot_id";

COMMIT;
