-- Deploy burningswell-db:user-profile-photos to pg

BEGIN;

CREATE TABLE user_profile_photos (
  photo_id INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  user_id INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX user_profile_photos_photo_id_user_id_idx ON user_profile_photos (photo_id, user_id);

CREATE TRIGGER user_profile_photos_created_at_trigger
  BEFORE INSERT ON user_profile_photos FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER user_profile_photos_updated_at_trigger
  BEFORE UPDATE ON user_profile_photos FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
