-- Deploy burningswell-db:flickr-users-table to pg

BEGIN;

CREATE TABLE flickr.users (
  id TEXT PRIMARY KEY,
  nsid TEXT UNIQUE,
  username TEXT,
  realname TEXT,
  location TEXT,
  profile_url TEXT,
  photos_url TEXT,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE TRIGGER flickr_users_created_at_trigger
  BEFORE INSERT ON flickr.users FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER flickr_users_updated_at_trigger
  BEFORE UPDATE ON flickr.users FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
