-- Deploy burningswell-db:flickr-photos-table to pg

BEGIN;

CREATE TABLE flickr.photos (
  id TEXT PRIMARY KEY,
  owner TEXT NOT NULL REFERENCES flickr.users(id) ON DELETE CASCADE,
  photo_id INTEGER REFERENCES photos(id) ON DELETE CASCADE,
  farm INTEGER NOT NULL,
  isfamily INTEGER NOT NULL,
  isfriend INTEGER NOT NULL,
  ispublic INTEGER NOT NULL,
  server TEXT NOT NULL,
  title TEXT,
  secret TEXT NOT NULL,
  url TEXT NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX flickr_photos_owner ON flickr.photos(owner);
CREATE INDEX flickr_photos_photo_id ON flickr.photos(photo_id);
CREATE INDEX flickr_photos_url ON flickr.photos(url);

CREATE TRIGGER flickr_photos_created_at_trigger
  BEFORE INSERT ON flickr.photos FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER flickr_photos_updated_at_trigger
  BEFORE UPDATE ON flickr.photos FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
