-- Deploy create_weather_datasources

BEGIN;

CREATE TABLE "weather"."datasources" (
  "id" SERIAL PRIMARY KEY,
  "model_id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "reference_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "das" TEXT NOT NULL UNIQUE,
  "dds" TEXT NOT NULL UNIQUE,
  "dods" TEXT NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather_datasources_model_id_variable_id_filename_index" ON "weather"."datasources" ("model_id", "reference_time");

CREATE TRIGGER "weather_datasources_created_at_trigger"
  BEFORE INSERT ON "weather"."datasources" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_datasources_updated_at_trigger"
  BEFORE UPDATE ON "weather"."datasources" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

ALTER TABLE "weather"."datasets" ADD COLUMN "datasource_id" INTEGER REFERENCES "weather"."datasources" ON DELETE CASCADE;

ALTER TABLE "weather"."datasets" DROP COLUMN "das";
ALTER TABLE "weather"."datasets" DROP COLUMN "dds";
ALTER TABLE "weather"."datasets" DROP COLUMN "dods";
ALTER TABLE "weather"."datasets" DROP COLUMN "download_finished_at";
ALTER TABLE "weather"."datasets" DROP COLUMN "download_started_at";
ALTER TABLE "weather"."datasets" DROP COLUMN "filename";
ALTER TABLE "weather"."datasets" DROP COLUMN "filesize";
ALTER TABLE "weather"."datasets" DROP COLUMN "model_id";
ALTER TABLE "weather"."datasets" DROP COLUMN "reference_time";

CREATE UNIQUE INDEX "weather_datasets_datasource_id_variable_id_valid_time_index" ON "weather"."datasets" ("datasource_id", "variable_id", "valid_time");

COMMIT;
