-- Deploy create_weather_datasets

BEGIN;

CREATE TABLE "weather"."datasets" (
  "id" SERIAL PRIMARY KEY,
  "model_id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable_id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "reference_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "valid_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "das" TEXT NOT NULL,
  "dds" TEXT NOT NULL,
  "dods" TEXT NOT NULL,
  "filename" TEXT UNIQUE,
  "filesize" integer,
  "rast" raster,
  "download_started_at" TIMESTAMP WITH TIME ZONE,
  "download_finished_at" TIMESTAMP WITH TIME ZONE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather_datasets_model_id_variable_id_valid_time_index" ON "weather"."datasets" ("model_id", "variable_id", "valid_time");
CREATE UNIQUE INDEX "weather_datasets_model_id_variable_id_filename_index" ON "weather"."datasets" ("model_id", "variable_id", "filename");
CREATE INDEX "weather_datasets_rast_idx" ON "weather"."datasets" USING GIST (ST_ConvexHull("rast"));

CREATE TRIGGER "weather_datasets_created_at_trigger"
  BEFORE INSERT ON "weather"."datasets" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_datasets_updated_at_trigger"
  BEFORE UPDATE ON "weather"."datasets" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
