-- Deploy create_user_locations_table

BEGIN;

CREATE TABLE "user_locations" (
  "id" SERIAL PRIMARY KEY,
  "address_id" INTEGER REFERENCES "addresses"("id") ON DELETE SET NULL,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "location" GEOGRAPHY(POINT, 4326) NOT NULL,
  "last_seen_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "user_locations_location_index" ON "user_locations" USING gist(location);
CREATE INDEX "user_locations_user_id_index" ON "user_locations" ("user_id");

CREATE UNIQUE INDEX "user_locations_user_id_location_last_seen_at" ON "user_locations" ("user_id", "last_seen_at", "location");

CREATE TRIGGER "user_locations_created_at_trigger"
  BEFORE INSERT ON "user_locations" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "user_locations_updated_at_trigger"
  BEFORE UPDATE ON "user_locations" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
