-- Deploy country_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_country_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_country_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_country_counts_on_delete_trigger"
  AFTER DELETE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

CREATE TRIGGER "update_country_counts_on_insert_trigger"
  AFTER INSERT ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

CREATE TRIGGER "update_country_counts_on_update_trigger"
  AFTER UPDATE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

COMMIT;
