-- Deploy add_user_settings_table

BEGIN;

CREATE TABLE "user_settings" (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "units" TEXT CHECK ("units" IS NULL OR "units" = ANY ('{eu, uk, us}'::text[])),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "user_settings_user_index" ON "user_settings"("user_id");

CREATE TRIGGER "user_settings_created_at_trigger"
  BEFORE INSERT ON "user_settings" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "user_settings_updated_at_trigger"
  BEFORE UPDATE ON "user_settings" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
