-- Deploy user_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_user_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_user_count"();
  PERFORM "update_country_user_count"();
  PERFORM "update_region_user_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_user_counts_on_delete_trigger"
  AFTER DELETE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

CREATE TRIGGER "update_user_counts_on_insert_trigger"
  AFTER INSERT ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

CREATE TRIGGER "update_user_counts_on_update_trigger"
  AFTER UPDATE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

COMMIT;
