-- Deploy create_roles_table

BEGIN;

CREATE TABLE "roles" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL UNIQUE,
  "description" CITEXT NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "roles_name_fulltext_index" ON "roles" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "roles_created_at_trigger"
  BEFORE INSERT ON "roles" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "roles_updated_at_trigger"
  BEFORE UPDATE ON "roles" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
