-- Deploy create_ratings_table

BEGIN;

CREATE TABLE "ratings" (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "spot_id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "rating" INTEGER NOT NULL CONSTRAINT "valid_rating" CHECK ("rating" > 0 AND "rating" < 6),
  "rated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "ratings_spot_id_index" ON "ratings" ("spot_id");
CREATE UNIQUE INDEX "ratings_user_id_spot_id_rated_at_index" ON "ratings" ("user_id", "spot_id", "rated_at");

CREATE TRIGGER "ratings_created_at_trigger"
  BEFORE INSERT ON "ratings" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "ratings_updated_at_trigger"
  BEFORE UPDATE ON "ratings" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
