-- Deploy create_comments_table

BEGIN;

CREATE TABLE comments (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "spot_id" INTEGER NOT NULL REFERENCES spots(id) ON DELETE CASCADE,
  "content" CITEXT NOT NULL,
  "visible" TEXT NOT NULL DEFAULT 'public',
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX comments_name_fulltext_index ON comments USING gin(to_tsvector('english', content));
CREATE INDEX comments_user_id_index ON comments ("user_id");
CREATE INDEX comments_spot_id_index ON comments ("spot_id");
CREATE INDEX comments_visible_index ON comments (visible);

CREATE TRIGGER comments_created_at_trigger
  BEFORE INSERT ON comments FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER comments_updated_at_trigger
  BEFORE UPDATE ON comments FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
