-- Deploy update_country_spot_count

BEGIN;

CREATE OR REPLACE FUNCTION "update_country_spot_count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "spot_count" = u.count
    FROM (SELECT countries.id, count(spots.id)
            FROM countries
       LEFT JOIN spots
              ON spots."country_id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
