-- Deploy burningswell_db:twitter_schema to pg

BEGIN;

CREATE SCHEMA twitter;

CREATE TABLE twitter.users (
  "id" TEXT PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "twitter_users_user_id_idx" ON twitter.users ("user_id");

CREATE TRIGGER "twitter_users_before_insert_created_at"
  BEFORE INSERT ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "twitter_users_before_insert_updated_at"
  BEFORE INSERT ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE TRIGGER "twitter_users_before_update_updated_at"
  BEFORE UPDATE ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
