-- Deploy port_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_port_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_port_count"();
  PERFORM "update_country_port_count"();
  PERFORM "update_region_port_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_port_counts_on_delete_trigger"
  AFTER DELETE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();

CREATE TRIGGER "update_port_counts_on_insert_trigger"
  AFTER INSERT ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();

CREATE TRIGGER "update_port_counts_on_update_trigger"
  AFTER UPDATE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();

COMMIT;
