-- Deploy photo_likes

BEGIN;

ALTER TABLE "photos" ADD COLUMN "likes" INTEGER DEFAULT 0;
ALTER TABLE "photos" ADD COLUMN "dislikes" INTEGER DEFAULT 0;

CREATE TABLE "photo_likes" (
  "photo_id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "like" BOOLEAN NOT NULL,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "photo_likes_photo_id_user_id_idx" ON "photo_likes" ("photo_id", "user_id");

CREATE TRIGGER "photo_likes_created_at_trigger"
  BEFORE INSERT ON "photo_likes" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "photo_likes_updated_at_trigger"
  BEFORE UPDATE ON "photo_likes" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
