-- Deploy burningswell_db:linkedin_schema to pg

BEGIN;

CREATE SCHEMA linkedin;

CREATE TABLE linkedin.users (
  "id" TEXT PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "linkedin_users_user_id_idx" ON linkedin.users ("user_id");

CREATE TRIGGER "linkedin_users_before_insert_created_at"
  BEFORE INSERT ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "linkedin_users_before_insert_updated_at"
  BEFORE INSERT ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE TRIGGER "linkedin_users_before_update_updated_at"
  BEFORE UPDATE ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
