-- Deploy eu_value

BEGIN;

CREATE OR REPLACE FUNCTION "eu_value"(value DOUBLE PRECISION, unit TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE unit
  WHEN 'k' THEN
    RETURN kelvin_to_celsius(value);
  WHEN 'm/s' THEN
    RETURN meter_per_second_to_km_per_hour(value);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
