-- Deploy delete_images

BEGIN;

DROP VIEW "thumbnails";
DROP TABLE "images";

ALTER TABLE "photos" DROP COLUMN "spot_id";

ALTER TABLE "photos" ADD COLUMN "content_length" INTEGER CHECK ("content_length" >= 0);
ALTER TABLE "photos" ADD COLUMN "content_md5" TEXT;
ALTER TABLE "photos" ADD COLUMN "content_type" TEXT;
ALTER TABLE "photos" ADD COLUMN "height" INTEGER CHECK ("height" >= 0);
ALTER TABLE "photos" ADD COLUMN "original_url" TEXT;
ALTER TABLE "photos" ADD COLUMN "s3_key" TEXT;
ALTER TABLE "photos" ADD COLUMN "status" TEXT DEFAULT 'created';
ALTER TABLE "photos" ADD COLUMN "width" INTEGER CHECK ("width" >= 0);

ALTER TABLE "photos" ADD COLUMN "flickr_url" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr_owner_id" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr_owner_name" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr_owner_url" TEXT;

CREATE INDEX "photos_original_url_idx" ON "photos" ("original_url");

CREATE TABLE "photos_spots" (
  "photo_id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "spot_id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "user_id" INTEGER REFERENCES "users"("id") ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "photos_spots_photo_id_idx" ON "photos_spots" ("photo_id");
CREATE INDEX "photos_spots_spot_id_idx" ON "photos_spots" ("spot_id");
CREATE INDEX "photos_spots_user_id_idx" ON "photos_spots" ("user_id");

CREATE UNIQUE INDEX "photos_spots_photo_id_spot_ididx" ON "photos_spots" ("photo_id", "spot_id");

CREATE TRIGGER "photos_spots_created_at_trigger"
  BEFORE INSERT ON "photos_spots" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "photos_spots_updated_at_trigger"
  BEFORE UPDATE ON "photos_spots" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
