-- Deploy create_spots_users_table

BEGIN;

CREATE TABLE "spots_users" (
  "spot_id" INTEGER NOT NULL REFERENCES spots(id) ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "spots_users_spot_id_user_id_index" ON "spots_users"("spot_id", "user_id");

CREATE TRIGGER "spots_users_created_at_trigger"
  BEFORE INSERT ON "spots_users" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "spots_users_updated_at_trigger"
  BEFORE UPDATE ON "spots_users" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
