-- Deploy create_sessions_table

BEGIN;

CREATE TABLE "sessions" (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "spot_id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "started_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp() - interval '1 hour',
  "stopped_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "rating" INTEGER NOT NULL CONSTRAINT "valid_rating" CHECK ("rating" > 0 AND "rating" < 6),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "sessions_user_id_index" ON "sessions" ("user_id");
CREATE INDEX "sessions_spot_id_index" ON "sessions" ("spot_id");

CREATE TRIGGER "sessions_created_at_trigger"
  BEFORE INSERT ON "sessions" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "sessions_updated_at_trigger"
  BEFORE UPDATE ON "sessions" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
