-- Deploy create_region_forecasts

BEGIN;

CREATE TABLE "weather"."region_forecasts" (
  "id" SERIAL PRIMARY KEY,
  "region_id" INTEGER NOT NULL REFERENCES "regions"("id") ON DELETE CASCADE,
  "variable_id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "valid_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "value" FLOAT,
  "avg_value" FLOAT,
  "min_value" FLOAT,
  "max_value" FLOAT,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather_region_forecasts_region_id_valid_time_variable_id_index" ON "weather"."region_forecasts" ("region_id", "valid_time", "variable_id");

CREATE TRIGGER "weather_region_forecasts_created_at_trigger"
  BEFORE INSERT ON "weather"."region_forecasts" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_region_forecasts_updated_at_trigger"
  BEFORE UPDATE ON "weather"."region_forecasts" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
