-- Deploy create_raster_table

BEGIN;

ALTER TABLE "weather"."datasets" DROP COLUMN "rast";

CREATE TABLE "weather"."rasters" (
  "id" SERIAL PRIMARY KEY,
  "dataset_id" INTEGER NOT NULL REFERENCES "weather"."datasets"("id") ON DELETE CASCADE,
  "rast" raster,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "weather_rasters_rast_idx" ON "weather"."rasters" USING GIST (ST_ConvexHull("rast"));

CREATE TRIGGER "weather_rasters_created_at_trigger"
  BEFORE INSERT ON "weather"."rasters" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_rasters_updated_at_trigger"
  BEFORE UPDATE ON "weather"."rasters" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
