-- Deploy create_ports_table

BEGIN;

CREATE TABLE "ports" (
  "id" SERIAL PRIMARY KEY,
  "country_id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region_id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "name" CITEXT UNIQUE NOT NULL,
  "type" CITEXT NOT NULL,
  "website_url" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "ports_name_fulltext_index" ON "ports" USING gin(to_tsvector('english', "name"));
CREATE INDEX "ports_location_index" ON "ports" USING gist("location");

CREATE TRIGGER "ports_created_at_trigger"
  BEFORE INSERT ON "ports" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "ports_updated_at_trigger"
  BEFORE UPDATE ON "ports" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
