-- Deploy create_images_table

BEGIN;

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "width" INTEGER NOT NULL,
  "height" INTEGER NOT NULL,
  "label" TEXT NOT NULL,
  "url" TEXT NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "images_photo_id_index" ON "images" ("photo_id");
CREATE INDEX "images_photo_id_width_height_index" ON "images" ("photo_id", "width", "height");
CREATE INDEX "images_width_index" ON "images" ("width");
CREATE INDEX "images_width_height_index" ON "images" ("width", "height");
CREATE INDEX "images_height_index" ON "images" ("height");

CREATE TRIGGER "images_created_at_trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "images_updated_at_trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
