-- Deploy create_followings_table

BEGIN;

CREATE TABLE followings (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "follower_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "accepted_at" TIMESTAMP WITH TIME ZONE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "followings_user_id_follower_id_index" ON followings("user_id", "follower_id");
CREATE UNIQUE INDEX "followings_follower_id_user_id_index" ON followings("follower_id", "user_id");

CREATE TRIGGER "followings_created_at_trigger"
  BEFORE INSERT ON followings FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "followings_updated_at_trigger"
  BEFORE UPDATE ON followings FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
