--_ Deploy create_addresses_table

BEGIN;

CREATE TABLE "addresses" (
  "id" SERIAL PRIMARY KEY,
  "country_id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region_id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "formatted" CITEXT NOT NULL,
  "street_name" CITEXT,
  "street_number" CITEXT,
  "postal_code" CITEXT,
  "city" CITEXT,
  "location" GEOMETRY(POINT, 4326) NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "addresses_location_index" ON addresses USING gist(location);

CREATE TRIGGER "addresses_created_at_trigger"
  BEFORE INSERT ON "addresses" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "addresses_updated_at_trigger"
  BEFORE UPDATE ON "addresses" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
