-- Deploy add_user_to_role

BEGIN;

CREATE OR REPLACE FUNCTION "add_user_to_role"("user_id" integer, "role_id" integer)
RETURNS void AS $$
#variable_conflict use_variable
BEGIN
  INSERT INTO "roles_users" ("user_id", "role_id")
    SELECT "user_id", "role_id"
     WHERE NOT EXISTS
       (SELECT *
          FROM "roles_users"
         WHERE "roles_users"."user_id" = "user_id"
           AND "roles_users"."role_id" = "role_id");
END;
$$ LANGUAGE plpgsql;

COMMIT;
