(ns burningswell.db.time-zones
  (:require [burningswell.db.util :as util]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]
            [datumbazo.table :as t]))

(t/deftable time-zones
  "The time zones table."
  (t/column :created-at :timestamp :not-null? true)
  (t/column :geom :geography)
  (t/column :id :integer :primary-key? true)
  (t/column :natural-earth-id :integer)
  (t/column :offset :integer)
  (t/column :places :text) ;; TODO array
  (t/column :updated-at :timestamp :not-null? true))

(defn by-location
  "Return the time zone in `db` for `location`."
  [db location & [opts]]
  (first @(sql/select db [:*]
            (sql/from :time-zones)
            (sql/where `(st_intersects
                         :time-zones.geom
                         (cast ~location :geography))))))

(defn search
  "Search time-zones."
  [db & [{:keys [direction limit offset sort query] :as opts}]]
  @(sql/select db [:time-zones.id]
     (sql/from :time-zones)
     (util/fulltext query :places)
     (sql/limit limit)
     (sql/offset offset)
     (util/order-by :time-zones opts)))

(s/fdef search
  :args (s/cat :db sql/db? :opts (s/? map?))
  :ret (s/coll-of ::time-zone))
