(ns burningswell.db.oauth.providers
  (:require [clojure.spec.alpha :as s]
            [datumbazo.table :as t]
            [datumbazo.core :as sql]
            [clojure.string :as str]))

(t/deftable providers
  "The OAuth providers table."
  (t/table :oauth.providers)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :description :text)
  (t/column :id :integer :primary-key? true)
  (t/column :name :citext :unique? true)
  (t/column :updated-at :timestamp :not-null? true))

(defn search
  "Search all OAuth providers."
  [db & [{:keys [sort limit offset]}]]
  @(sql/select db [:providers.id]
     (sql/from :oauth.providers)
     (sql/limit limit)
     (sql/offset limit)
     (sql/order-by (keyword (or sort :name)))))
