(ns burningswell.db.main
  (:gen-class)
  (:require [burningswell.db.counter-caches :as counter-caches]
            [burningswell.db.fixtures :as fixtures]
            [burningswell.db.materialized-views :as materialized-views]))

(defn- exit [message]
  (println (str "bs-db: " message)))

(defn -main [& [cmd & args]]
  (case (keyword cmd)
    :counter-caches (apply counter-caches/-main args)
    :fixtures (apply fixtures/-main args)
    :materialized-views (apply materialized-views/-main args)
    nil (exit "No command given.")
    (exit (format "Unknown command: %s." cmd))))
