(ns burningswell.db.followings
  (:require [clojure.string :as str]
            [datumbazo.core :as sql]
            [datumbazo.table :as t]
            [clojure.spec.alpha :as s]))

(t/deftable followings
  "The followings table."
  (t/column :id :integer :primary-key? true)
  (t/column :user-id :integer)
  (t/column :follower-id :integer)
  (t/column :accepted-at :timestamp)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :updated-at :timestamp :not-null? true))

;; (deftable followings
;;   "The followings database table."
;;   (column :id :serial :primary-key? true)
;;   (column :user-id :integer :references :users/id)
;;   (column :follower-id :integer :references :users/id)
;;   (column :accepted-at :timestamp-with-time-zone)
;;   (column :created-at :timestamp-with-time-zone
;;           :not-null? true :default '(now))
;;   (column :updated-at :timestamp-with-time-zone
;;           :not-null? true :default '(now)))

;; (defquery followers-of-user
;;   "Returns all followers of `user`."
;;   [db user & [opts]]
;;   (compose (#'users/select-all db opts)
;;            (join :followings.follower-id :users.id)
;;            (where `(= :followings.user-id ~(:id user)))
;;            (order-by :followings.created-at)))

;; (defquery1 following-for-user-and-follower
;;   "Returns the following for `user` and `follower`."
;;   [db user follower]
;;   (compose (followings* db)
;;            (where `(and (= :followings.user-id ~(:id user))
;;                         (= :followings.follower-id ~(:id follower))))))
