(ns burningswell.db.flickr.photo-sizes
  (:require [datumbazo.table :as t]))

(t/deftable photo-sizes
  "The Flickr photo sizes table."
  (t/table :flickr.photo-sizes)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :height :integer :not-null? true)
  (t/column :id :serial)
  (t/column :label :text :primary-key? true)
  (t/column :media :text :not-null? true)
  (t/column :photo-id :text :not-null? true :references :flickr.photos.id :primary-key? true)
  (t/column :source :text :not-null? true)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :url :text :not-null? true)
  (t/column :width :integer :not-null? true))
