-- Deploy spot_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_spot_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_spot_count"();
  PERFORM "update_country_spot_count"();
  PERFORM "update_region_spot_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_spot_counts_on_delete_trigger"
  AFTER DELETE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

CREATE TRIGGER "update_spot_counts_on_insert_trigger"
  AFTER INSERT ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

CREATE TRIGGER "update_spot_counts_on_update_trigger"
  AFTER UPDATE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

COMMIT;
