-- Deploy region_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_region_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_region_count"();
  PERFORM "update_country_region_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_region_counts_on_delete_trigger"
  AFTER DELETE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

CREATE TRIGGER "update_region_counts_on_insert_trigger"
  AFTER INSERT ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

CREATE TRIGGER "update_region_counts_on_update_trigger"
  AFTER UPDATE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

COMMIT;
