(ns burningswell.db.counter-caches
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :as db]
            [burningswell.db.continents :as continents]
            [burningswell.db.countries :as countries]
            [burningswell.db.regions :as regions]
            [clojure.tools.logging :as log]
            [commandline.core :as cli]
            [environ.core :refer [env]]))

(def tables
  "The counter caches."
  [:continents
   :countries
   :regions])

(defmulti update-counter-cache!
  "Update the give `counter-cache`."
  (fn [db counter-cache]
    (keyword counter-cache)))

(defmethod update-counter-cache! :continents [db _]
  (continents/update-counters! db))

(defmethod update-counter-cache! :countries [db _]
  (countries/update-counters! db))

(defmethod update-counter-cache! :regions [db _]
  (regions/update-counters! db))

(defn run [db & [args]]
  (cli/with-commandline [[opts args] args]
    [[h help "Print this help."]]
    (if (:help opts)
      (cli/print-help "counter-caches [OPTION...] [CACHE,...]")
      (let [tables (or (not-empty (map keyword args)) tables)]
        (doseq [table tables]
          (update-counter-cache! db table)
          (log/infof
           "Successfully updated the counter cache for the \"%s\" table."
           (name table)))
        tables))))

(defn -main [& args]
  (db/with-db [db (config/db env)]
    (run db args)))
