-- Deploy create_time_zones_table

BEGIN;

CREATE TABLE "time_zones" (
  "id" SERIAL PRIMARY KEY,
  "natural_earth_id" INTEGER UNIQUE NOT NULL,
  "offset" INTEGER NOT NULL,
  "places" TEXT[] NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "time_zones_geom_index" ON "time_zones" USING gist(geom);

CREATE TRIGGER "time_zones_created_at_trigger"
  BEFORE INSERT ON "time_zones" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "time_zones_updated_at_trigger"
  BEFORE UPDATE ON "time_zones" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
