-- Deploy convert_value

BEGIN;

CREATE OR REPLACE FUNCTION "convert_value"(value DOUBLE PRECISION, unit TEXT, target TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE target
  WHEN 'eu' THEN
    RETURN "eu_value"(value, unit);
  WHEN 'uk' THEN
    RETURN "uk_value"(value, unit);
  WHEN 'us' THEN
    RETURN "us_value"(value, unit);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
