-- Revert burningswell_db:drop_weather_spot_forecasts from pg

BEGIN;

CREATE MATERIALIZED VIEW weather."spot_forecasts" AS
  SELECT *
    FROM weather."spots"
   WHERE "valid_time" >= date_trunc('day', clock_timestamp())
   ORDER BY "spot_id", "valid_time";

CREATE INDEX "weather_spot_forecasts_spot_id_valid_time" ON weather."spot_forecasts" ("spot_id", "valid_time");
CREATE UNIQUE INDEX "weather_spot_forecasts_spot_id_variable_id_valid_time" ON weather."spot_forecasts" ("spot_id", "variable_id", "valid_time");

CREATE MATERIALIZED VIEW weather."spot_nowcasts" AS
  SELECT DISTINCT ON ("spot_id", "variable_id") *
    FROM weather."spot_forecasts"
   WHERE "valid_time" >= clock_timestamp()
   ORDER BY "spot_id", "variable_id", "valid_time";

CREATE INDEX "weather_spot_nowcasts_spot_id" ON weather."spot_nowcasts" ("spot_id");
CREATE UNIQUE INDEX "weather_spot_nowcasts_spot_id_variable_id_valid_time" ON weather."spot_nowcasts" ("spot_id", "variable_id", "valid_time");

COMMIT;
