-- Deploy update_country_user_count

BEGIN;

CREATE OR REPLACE FUNCTION "update_country_user_count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "user_count" = u.count
    FROM (SELECT countries.id, count(users.id)
            FROM countries
       LEFT JOIN users
              ON users."country_id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
