-- Deploy burningswell-db:gravatar-images to pg

BEGIN;

CREATE TABLE gravatar.images (
  user_id TEXT NOT NULL REFERENCES gravatar.users(id) ON DELETE CASCADE,
  url TEXT NOT NULL,
  type TEXT NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL,
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL,
  PRIMARY KEY (user_id, url, type)
);

CREATE INDEX gravatar_images_user_id ON gravatar.images(user_id);
CREATE INDEX gravatar_images_url ON gravatar.images(url);

CREATE TRIGGER gravatar_images_before_insert_created_at
  BEFORE INSERT ON gravatar.images FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER gravatar_images_before_insert_updated_at
  BEFORE INSERT ON gravatar.images FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

CREATE TRIGGER gravatar_images_before_update_updated_at
  BEFORE UPDATE ON gravatar.images FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
