-- Deploy create_weather_models_variables_table

BEGIN;

CREATE TABLE "weather"."models_variables" (
  "model_id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable_id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather_models_variables_model_id_variable_id_index"
  ON "weather"."models_variables"("model_id", "variable_id");

CREATE TRIGGER "weather_models_variables_created_at_trigger"
  BEFORE INSERT ON "weather"."models_variables" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_models_variables_updated_at_trigger"
  BEFORE UPDATE ON "weather"."models_variables" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
