-- Deploy create_photo_labels_table

BEGIN;

CREATE TABLE "photo_labels" (
  "id" SERIAL PRIMARY KEY,
  "mid" TEXT NOT NULL UNIQUE,
  "description" CITEXT NOT NULL,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE TRIGGER "photo_labels_created_at_trigger"
  BEFORE INSERT ON "photo_labels" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "photo_labels_updated_at_trigger"
  BEFORE UPDATE ON "photo_labels" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
