-- Deploy add_weather_raster_timestamps

BEGIN;

ALTER TABLE weather.rasters ADD COLUMN "model_id" INTEGER NOT NULL REFERENCES weather.models(id) ON DELETE CASCADE;
ALTER TABLE weather.rasters ADD COLUMN "variable_id" INTEGER NOT NULL REFERENCES weather.variables(id) ON DELETE CASCADE;
ALTER TABLE weather.rasters ADD COLUMN "valid_time" TIMESTAMP WITH TIME ZONE NOT NULL;
ALTER TABLE weather.rasters ADD COLUMN "reference_time" TIMESTAMP WITH TIME ZONE NOT NULL;

CREATE INDEX "weather_rasters_model_id_index" ON weather."rasters" ("model_id");
CREATE INDEX "weather_rasters_variable_id_index" ON weather."rasters" ("variable_id");
CREATE INDEX "weather_rasters_valid_time_index" ON weather."rasters" ("valid_time");

COMMIT;
